﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;

namespace VIRP
{
    [Serializable]
    public class ValidationErrorsCollection : Collection<ValidationError>
    {
        public ValidationErrorsCollection()
        {
        }

        internal ValidationErrorsCollection(IList<ValidationError> myList) : base(myList)
        {
        }

        public ValidationErrorsCollection FindByPropertyName(string propertyName)
        {
            return new ValidationErrorsCollection((from rule in this
                                                   where rule.PropertyName.ToUpperInvariant() == propertyName.ToUpperInvariant()
                                                   select rule).ToList<ValidationError>());
        }

        public ValidationErrorsCollection FindByMessage(string message)
        {
            return new ValidationErrorsCollection((from rule in this
                                                   where rule.Message.ToUpperInvariant().Contains(message.ToUpperInvariant())
                                                   select rule).ToList<ValidationError>());
        }

        public void Add(string message)
        {
            Add(new ValidationError(string.Empty, message));
        }

        public void Add(string propertyName, string message)
        {
            if (this.FindByPropertyName(propertyName).Count == 0)
                Add(new ValidationError(propertyName, message));
        }

        public override string ToString()
        {
            StringBuilder myStringBuilder = new StringBuilder();
            foreach (ValidationError item in this)
            {
                myStringBuilder.Append(string.Format("{0}\\r\\n", item.ToString()));
            }
            return myStringBuilder.ToString();
        }
    }
}
